/*------------------------------------------------------------------------------*
 * File Name: LabTalk Variables Editor 											*
 * Creation: CPY 07/01/2005														*
 * Purpose: Loose Dataset and other LT variables viewing and deleting			*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION									*
 *	Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG									*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
//#include "TreeEditSplitter.h"	///Jasmine 10/20/05 BOTTOM_PANE_MODIFICATION
#include "LTVarDlg.h"
static 	LTVarEditDlg*	 s_pLTVarDlg = NULL;


BOOL LTVarEditDlg::OnDestroy()
{		
	///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
	//m_nShowStatus = m_VarList.GetVarListShowStatus();
	//SaveSetting(m_strShowStatus, m_nShowStatus, STR_DLG_NAME);
	updateVarListShowStatusRegister(false); // to register
	///---END QA81-14106 IMPROVE_ED_DIALOG

	MultiPaneDlg::OnDestroy();	
	if(m_bDeleteOnDestroy)
	{
		delete this;
		s_pLTVarDlg = NULL;
	}
	//return MultiPaneDlg::OnDestroy();  ///Iris 10/14/05 move to the top since SaveSeetings fail to work here
	return true;
}


// generic func prototype for VC level calling
int LTVarDlg(int nMsg=0, DWORD dwCntrl=0, LPVOID lpData = NULL)
{
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;

	if(bClose)
	{
		if(s_pLTVarDlg)
		{
			Window winDlg = s_pLTVarDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			
			delete s_pLTVarDlg;
			s_pLTVarDlg = NULL;
		}
		return 0;
	}
	if(s_pLTVarDlg)// reentrance, 
	{
		out_str("Dialog already open");
		return -1;
	}
	
	// open or update
	if( !s_pLTVarDlg )
	{
		if(bUpdate)
			return 1;// not possible to update, since dialog not opened
	
		s_pLTVarDlg = new LTVarEditDlg(true);
		s_pLTVarDlg->Create(GetWindow());
	}
		
	if(bUpdate)
		s_pLTVarDlg->Update();//"from global message");
	
	return 0;
}

//--- CPY temp
/*
	OMSG_OPEN = 0,
	OMSG_CLOSE,
	OMSG_UPDATE,
*/
void testLTVar(int nCmd)
{
	LTVarDlg(nCmd);
}
//---
